<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackageVariationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('package_variations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_product_id');
            $table->foreignId('variant_id');
            $table->integer('quantity');
            $table->float('total');
            $table->timestamps();

            $table->foreign('package_product_id')->references('id')->on('package_prodcuts')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('package_variations');
    }
}
