<?php

namespace Database\Seeders;

use App\Models\Brands\Brand;
use App\Models\Categories\Category;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        Role::create(['name' => 'admin']);
        Role::create(['name' => 'customer']);
        Role::create(['name' => 'delivery']);
        Role::create(['name' => 'merchant']);

        Permission::create(['name' => 'wallet']);

        $admin = User::factory()->create([
            'name' => 'Inarrive Admin',
            'email' => 'admin@inarrive.com',
        ]);

        $superAdmin = User::factory()->create([
            'name' => 'Inarrive Super Admin',
            'email' => 'super-admin@inarrive.com',
        ]);

        $superAdmin->givePermissionTo('wallet');

        $admin->assignRole('admin');
        $superAdmin->assignRole('admin');
    }
}
