@extends('layouts.admin')

@section('title', 'Edit Category')

@section('content')
<div class="card">
    <form method="POST" action="{{ route('categories.update', $category->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div class="card-body">
            <div class="row">
                <div class="row col-md-12">
                    <div class="col-md-4">
                        <img id="imgProduct" src="{{ Storage::url($category->image) }}"
                            style="height: 100px; border-radius: 4px;">
                    </div>
                    <div class="col-md-4">
                        <img id="imgProduct1" src="{{ Storage::url($category->banner1) }}"
                            style="height: 100px; border-radius: 4px;">
                    </div>
                    <div class="col-md-4">
                        <img id="imgProduct2" src="{{ Storage::url($category->banner2) }}"
                            style="height: 100px; border-radius: 4px;">
                    </div>
                </div>

                <div class="row col-md-12">
                    <div class="col-md-4">
                        <x-input-file :required="false" id="inputProduct" label="Select Category Image"
                            img="imgProduct" />
                    </div>
                    <div class="col-md-4">
                        <x-input-file :required="false" name="banner1" id="inputProduct1" label="Select First Banner"
                            img="imgProduct1" />
                    </div>
                    <div class="col-md-4">
                        <x-input-file :required="false" name="banner2" id="inputProduct2" label="Select Second Banner"
                            img="imgProduct2" />
                    </div>
                </div>

                <div class="col-md-6">
                    <x-input-form :value="$category->name" id="name" name="name" label="Category Name" />
                </div>

                <div class="col-md-6">
                    <x-input-select :required="false" :disabled="false" label="Type" name="type" id="type">
                        <option value="special" {{$category->type == 'special' ? 'selected' : ''}}>Special</option>
                    </x-input-select>
                </div>

                <div class="col-md-12">
                    <x-status :value="$category->status" />
                </div>
            </div>
        </div>

        <input type="hidden" name="url" value="{{ url()->previous() }}">

        <x-btn-submit :update="true" />

    </form>
</div>
@endsection
