@extends('layouts.admin')

@section('title', 'Edit Customer')

@section('content')
<div class="card mt-4">
    <form method="POST" action="{{ route('customers.update',$customer->id)}}" enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div class="card-body">

            <div class="row">
                <div class="col-md-6">
                    <x-input-form id="name" name="name" label="Customer Name" :value="$customer->name" />
                </div>

                <div class="col-md-6">
                    <x-input-form id="email" name="email" type="email" label="Customer Email"
                        :value="$customer->email" />
                </div>

                <div class="col-md-6">
                    <x-input-form id="address" name="address" label="Customer Address" :value="$customer->address" />
                </div>

                <div class="col-md-6">
                    <x-input-form id="password" name="password" type="password" label="Password"
                        :value="$customer->password" />
                </div>

                <div class="col-md-6">
                    <x-status :value="$customer->status" />
                </div>

            </div>
        </div>


        <x-btn-submit :update="true"/>

    </form>
</div>

@endsection