@extends('layouts.admin')

@section('title', 'Dashboard')

@section('content')
<div class="row">
  <div class="col-lg-3 col-6">
    <div class="small-box bg-info">
      <div class="inner">
        <h3>{{ $countProduct }}</h3>
        <p>Products</p>
      </div>
    </div>
  </div>
  <div class="col-lg-3 col-6">
    <div class="small-box bg-danger">
      <div class="inner">
        <h3>{{ $countCategory }}</h3>
        <p>Categories</p>
      </div>
    </div>
  </div>
  <div class="col-lg-3 col-6">
    <div class="small-box bg-warning">
      <div class="inner">
        <h3>{{ $countCustomer }}</h3>
        <p>Customer</p>
      </div>
    </div>
  </div>
  <div class="col-lg-3 col-6">
    <div class="small-box bg-danger">
      <div class="inner">
        <h3>{{ $countOrder }}</h3>
        <p> Orders</p>
      </div>
    </div>
  </div>
</div>

{{-- Customers --}}
<div class="row">
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header border-0">
        <h3 class="card-title">Customers</h3>
        <div class="card-tools">

        </div>
      </div>
      <div class="card-body table-responsive p-0">
        <table class="table table-striped table-valign-middle">
          <thead>
            <tr>
              <th>Name</th>
              <th>Email</th>
            </tr>
          </thead>
          <tbody>
            @foreach($customer as $customers)
            <tr>
              <td>{{$customers->name}}</td>
              <td class="text-blue">{{$customers->email}}</td>
            </tr>
            @endforeach

          </tbody>
        </table>
      </div>
    </div>

    <!-- /.card -->

    <div class="card">
      <div class="card-header border-0">
        <h3 class="card-title">Products</h3>
      </div>
      <div class="card-body table-responsive p-0">
        <table class="table table-striped table-valign-middle">
          <thead>
            <tr>
              <th>Product</th>
              <th>Image</th>
            </tr>
          </thead>
          <tbody>
            @foreach($product as $products)
            <tr>
              <td>{{$products->name}}</td>
              <td>
                <img src="{{Storage::url($products->image)}}"
                  style="height: 60px; margin-bottom: 5px; border-radius: 4px;">
              </td>
            </tr>
            @endforeach

          </tbody>
        </table>
      </div>
    </div>
    <!-- /.card -->
  </div>

  <!-- /.col-md-6 -->
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header border-0">
        <h3 class="card-title">Categories</h3>
        <div class="card-tools">

        </div>
      </div>
      <div class="card-body table-responsive p-0">
        <table class="table table-striped table-valign-middle">
          <thead>
            <tr>
              <th>Name</th>
              <th>Image</th>
            </tr>
          </thead>
          <tbody>
            @foreach($category as $categorys)
            <tr>
              <td>{{$categorys->name}}</td>
              <td>
                <img src="{{Storage::url($categorys->image)}}"
                  style="height: 60px; margin-bottom: 5px; border-radius: 4px;">
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
    <!-- /.card -->

    <div class="card">
      <div class="card-header border-0">
        <h3 class="card-title">Brand</h3>
        <div class="card-tools">

        </div>
      </div>
      <div class="card-body table-responsive p-0">
        <table class="table table-striped table-valign-middle">
          <thead>
            <tr>
              <th>Name</th>
              <th>Image</th>
            </tr>
          </thead>
          <tbody>
            @foreach($brand as $brands)
            <tr>
              <td>{{$brands->name}}</td>
              <td> <img src="{{Storage::url($brands->image)}}"
                  style="height: 60px; margin-bottom: 5px; border-radius: 4px;"></td>
            </tr>
            @endforeach

          </tbody>
        </table>
      </div>
    </div>
  </div>
  <!-- /.col-md-6 -->
</div>

@endsection

@push('style')
<style type="text/css">
  .blue-bg {
    color: #fff;
    background: #57889c;
    background-color: #57889c;
  }

  .info-box {
    min-height: 140px;
    margin-bottom: 30px;
    padding: 20px;
    margin-top: 10px;

    box-shadow: inset 0 0 1px 1px rgba(255, 255, 255, 0.35), 0 3px 1px -1px rgba(0, 0, 0, 0.1);
  }

  .info-box .count {
    margin-top: 20px;
    font-size: 34px;
    font-weight: 700;
  }

  .info-box .title {
    font-size: 12px;
    text-transform: uppercase;
    font-weight: 600;
    padding-top: 30%;
    margin-left: -15%;
  }

  .brown-bg {
    color: #fff;
    background: #d1b993;
    background-color: #d1b993;
  }

  .dark-bg {
    color: #fff;
    background: #1a2732;
    background-color: #1a2732;
  }

  .green-bg {
    color: #fff;
    background: #26c281;
    background-color: #26c281;
  }

  .info-box i {
    display: block;
    height: 100px;
    font-size: 60px;
    line-height: 100px;
    width: 100px;
    float: left;
    text-align: center;
    margin-right: 20px;
    padding-right: 20px;
    color: rgba(255, 255, 255, 0.75);
  }

  .content a {
    text-decoration: none;
  }
</style>
@endpush
