@extends('layouts.admin')

@section('title', 'Edit Deals')

@section('content')
<div class="card">
    <form method="POST" action="{{ route('deals.update', $deal->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div class="card-body">
            <div class="row">


                <div class="col-md-6">
                    <x-input-form :value="$deal->name" id="name" name="name" label="Name" />
                </div>

                <div class="col-md-6">
                    <x-input-select :disabled="false" :required="false" label="Place (Where you want to show?)"
                                    name="place"
                                    id="place">
                        <option value="home" {{ $deal->place == 'home'? 'selected': '' }}>
                            Home Screen
                        </option>
                        <option value="category" {{ $deal->place == 'category'? 'selected': '' }}>
                            Category Screen
                        </option>
                    </x-input-select>
                </div>

                <div class="col-md-6">
                    <x-input-form :value="$deal->sort" :required="false" type="number" id="sort" name="sort" label="Sort"/>
                </div>

                <div class="col-md-6">
                    <x-status :value="$deal->status" />
                </div>
            </div>
        </div>


        <x-btn-submit :update="true"/>

    </form>
</div>
@endsection
