@extends('layouts.admin')

@section('title', 'Deal Product')

@section('content')
<div x-data="data()">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Deal Details</h3>
        </div>

        <div class="card-body">
            <div class="row">

                <div class="col-md-6 form-group">
                    <label for="input-name">Deal Name</label>
                    <input value="{{ $deal->name }}" name="name" type="text" class="form-control" id="name"
                        placeholder="Enter Name" required>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th width="5%">#</th>
                                <th width="10%">Product Name</th>
                                <th width="10%">Image</th>
                                <th width="10%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-for="(product, index) in selectedProducts">
                                <tr>
                                    <td x-text="product.id"></td>
                                    <td x-text="product.name"></td>
                                    <td>
                                        <img :src="'/storage/'+product.image"
                                            style="height: 30px; margin-bottom: 5px; border-radius: 4px;">
                                    </td>
                                    <td>
                                        <button @click="removeProduct(index)" type="button"
                                            class="btn btn-sm btn-outline-danger">
                                            <i class="fa fa-trash text-red"></i>
                                        </button>
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>

                <div class="col-md-12">
                    <div class="card" style="height: 170px;">
                        <div class="card-body d-flex" style="align-items: center;justify-content: center;background:#b7b7b7;">
                            <button class="btn btn-primary" data-toggle="modal" data-target="#myModal">Add Product</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-footer" style="background: white;">
            <button @click="submit()" class="btn btn-block btn-success">UPDATE</button>
        </div>
    </div>

    <!-- Product Modal -->
    <div class="modal" id="myModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">All Product</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <div>
                        <table id="products-table" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Image</th>
                                    <th>Select</th>
                                </tr>
                            </thead>
                            <tbody>
                                <template x-for="product in products">
                                    <tr>
                                        <td x-text="product.id"></td>
                                        <td x-text="product.name"></td>
                                        <td>
                                            <img :src="'/storage/'+product.image"
                                                style="height: 30px; margin-bottom: 5px; border-radius: 4px;">
                                        </td>
                                        <td>
                                            <button data-dismiss="modal" @click="selectProduct(product)" type="button"
                                                class="btn btn-primary">Select</button>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@push('scripts')
<script type="text/javascript">
    $(function () {
    $('#products-table').DataTable();
});

function data() {
    return {
        products: @json($products),
        selectedProducts: @json($deal->products),

        selectProduct(product) {
            const isAdded = this.selectedProducts.find(x => x.id === product.id);

            if(isAdded != null) {
                Swal.fire({
                    title: 'Peoduct Already Exists!',
                    text: 'Please Slect Another Product',
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
                return;
            }

            this.selectedProducts.push(product);
        },

        removeProduct(index) {
            this.selectedProducts.splice(index, 1);
        },

        submit() {
            const route = '{{ route('deals.products.update', $deal->id) }}';

            const ids = this.selectedProducts.map(item => item.id);

            axios
                .post(route, ids)
                .then(() => {
                    window.history.go(-1);
                });
        }
    };
}
</script>
@endpush
