@extends('layouts.admin')

@section('title', 'All Deliveries')

@section('content')
   <div class="card">
       <div class="card-body">
           <div class="row invoice-info">
               <div class="col-sm-6 invoice-col">
                   To
                   <address>
                       <strong>{{ $order->customer->name }}</strong><br>
                       {{ $order->address->house }},  {{ $order->address->road }}<br>
                       {{ $order->address->city }}, {{ $order->address->pin }}<br>
                       Phone: {{ $order->address->phone }}
                   </address>
               </div>
               <!-- /.col -->
               <div class="col-sm-6 invoice-col">
                   <b>Invoice #{{ $order->order_id }}</b><br>
                   <b>Order ID:</b> {{ $order->id }}<br>
                   <b>Order Date:</b> {{ $order->created_at->format('d-m-Y') }}<br>
               </div>
               <!-- /.col -->
           </div>
       </div>
   </div>

    <div class="card">
        <div class="card-body">
            <livewire:deliveries-table :order="$order"></livewire:deliveries-table>
        </div>
    </div>
@endsection
