@extends('layouts.admin')

@section('title', 'Create Delivery Partner')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('delivery-partners.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">

                <div class="row">

                    <div class="col-md-12">
                        <x-input-form id="name" name="name" label="Name" :required="false"></x-input-form>
                    </div>

                    <div class="col-md-12">
                        <x-input-form id="email" name="email" type="email" label="Email"></x-input-form>
                    </div>

                    <div class="col-md-12">
                        <x-input-form id="phone" name="phone" type="text" label="Phone"></x-input-form>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="postcode">Postcode</label>
                            <select name="postcode" id="postcode" class="form-control"
                                    required>
                                <option value="">Select Postcode</option>
                                @foreach($postcodes as $item)
                                    <option value="{{ $item->pincode }}">{{ $item->pincode }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <x-input-form id="password" name="password" type="text" label="Password"></x-input-form>
                    </div>


                </div>


            </div>

            <x-btn-submit></x-btn-submit>
        </form>
    </div>
@endsection
