@extends('layouts.admin')

@section('title', 'Edit Delivery Partner')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <form method="POST" action="{{ route('delivery-partners.update',$partner->id)}}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PATCH')

                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <x-input-form id="name" name="name" label="Name" :value="$partner->name"></x-input-form>
                            </div>

                            <div class="col-md-12">
                                <x-input-form id="email" name="email" label="Email"
                                              :value="$partner->email"></x-input-form>
                            </div>

                            <div class="col-md-12">
                                <x-input-form id="phone" name="phone" label="Phone"
                                              :value="$partner->phone"></x-input-form>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="postcode">Postcode</label>
                                    <select name="postcode" id="postcode" class="form-control"
                                            required>
                                        <option value="">Select Postcode</option>
                                        @foreach($postcodes as $item)
                                            <option
                                                value="{{ $item->pincode }}" {{ $partner->postcode == $item->pincode? 'selected': ''  }}>
                                                {{ $item->pincode }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <x-input-form id="password" name="password" type="password" label="Password"
                                              :required="false"></x-input-form>
                            </div>

                        </div>
                    </div>


                    <x-btn-submit :update="true"></x-btn-submit>

                </form>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Details</div>
                    <div class="card-text">
                        <dl>
                            <dt>Name</dt>
                            <dd>{{ $partner->name }}</dd>

                            <dt>Email</dt>
                            <dd>{{ $partner->email }}</dd>

                            <dt>Mobile</dt>
                            <dd>{{ $partner->phone }}</dd>

                            <dt>Since</dt>
                            <dd>{{ $partner->created_at->diffForHumans() }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
