@extends('layouts.admin')

@section('title', 'View Order Details')

@section('content')
    <form action="{{ route('orders.update', $order->id) }}" method="POST">
        @csrf
        @method('PATCH')
        <div class="card">
            <div class="card-header d-flex">
                <h3 class="card-title">Status</h3>
            </div>

            <div class="card-body">
                <div class="form-group">
                    <select name="status" id="status" class="custom-select @error('status')is-invalid @enderror">
                        <option value="">Select Status</option>
                        @foreach ($status as $item)
                            <option value="{{ $item}}" @if($item == $order->status) selected @endif>
                                {{ Str::upper($item) }}
                            </option>
                        @endforeach
                    </select>
                    @error('status')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary" style="float: right;">Change Status</button>
            </div>
        </div>
    </form>

    <form action="{{ route('orders.update', $order->id) }}" method="POST">
        @csrf
        @method('PATCH')

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header border-0">
                        <h3 class="card-title">Customer Details</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <strong><i class="fas fa-user mr-1"></i> Name</strong>

                        <p class="text-muted">
                            {{ $order->customer->name }}
                        </p>

                        <hr>

                        <strong><i class="fas fa-map-marker-alt mr-1"></i> Location</strong>

                        <p class="text-muted">
                            {{ $order->address->house }}, {{ $order->address->road }}
                            {{ $order->address->city }}, {{ $order->address->pin }}
                        </p>

                        <hr>

                        <strong><i class="fas fa-phone"></i> Contact</strong>

                        <p class="text-muted">
                            <span class="tag tag-danger">{{ $order->address->phone }}</span>
                        </p>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header border-0">
                        <h3 class="card-title">Products</h3>
                    </div>
                    <div class="card-body table-responsive p-0">
                        <table class="table table-striped table-valign-middle">
                            <tbody>
                            @foreach($order->products as $product)
                                <tr>
                                    <td>
                                        <img src="{{ Storage::url($product->product->image) }}" alt="Product 1"
                                             class="img-circle img-size-32 mr-2">
                                        {{ $product->product->name }}
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection

@push('style')
    <style>
        .card .card-header {
            background-color: white;
        }
    </style>
@endpush
