@extends('layouts.admin')

@section('title', 'Update Package')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('packages.update', $package->id) }}" enctype="multipart/form-data">
            @csrf
            @method('PATCH')
            <div class="card-body">
                <div class="row">

                    <div class="row col-md-12">
                        <div class="col-md-6">
                            <img id="imgPackage" src="{{ Storage::url($package->image) }}"
                                 style="height: 100px; border-radius: 4px;">
                        </div>
                        <div class="col-md-6">
                            <img id="imgBanner" src="{{ Storage::url($package->banner) }}"
                                 style="height: 100px; border-radius: 4px;">
                        </div>
                    </div>

                    <div class="row col-md-12">
                        <div class="col-md-6">
                            <x-input-file :required="false" id="filePackage" label="Select Package Image"
                                          img="imgPackage"/>
                        </div>
                        <div class="col-md-6">
                            <x-input-file :required="false" name="banner" id="fileBanner" label="Select Package Banner"
                                          img="imgBanner"/>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :value="$package->name" id="name" name="name" label="Package Name"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Package Duration" name="duration" id="duration">
                            <option value="7" {{$package->duration == '7' ? 'selected' : ''}}>7 Days</option>
                            <option value="30" {{$package->duration == '30' ? 'selected' : ''}}>30 Days</option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Package Group" name="group_id" id="group_id">
                            @foreach(\App\Models\Packages\PackageGroup::all() as $group)
                                <option
                                    value="{{ $group->id }}" {{$package->group_id == $group->id ? 'selected' : ''}}>
                                    {{ $group->name }}
                                </option>
                            @endforeach
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-status :value="$package->status"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Duscount Type" name="discount_type" id="discountType">
                            <option value="none" {{$package->discount_type == 'none' ? 'selected' : ''}}>
                                No Discount
                            </option>
                            <option value="flat" {{$package->discount_type == 'flat' ? 'selected' : ''}}>
                                Flat Discount
                            </option>
                            <option value="percentage" {{$package->discount_type == 'percentage' ? 'selected' : ''}}>
                                Percentage Discount
                            </option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :value="$package->discount" :required="false" type="number" id="discount"
                                      name="discount"
                                      label="Discount Amount"/>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="descripion">Package Description</label>
                        <textarea class="@error('description')is-invalid @enderror" name="description" id="descripion">
                        {{ $package->description }}
                    </textarea>
                        @error('description')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>

                </div>
            </div>

            <x-btn-submit :update="true"/>
        </form>
    </div>
@endsection
