@extends('layouts.admin')

@section('title', 'Package Product')

@section('content')
    <div id="someDiv" x-data="data()" x-init="check()">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Package Details</h3>
            </div>

            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 form-group">
                        <label for="exampleInputFile">Preview</label>
                        <div class="clearfix"></div>
                        <img src="{{  Storage::url($package->image) }}"
                             style="height: 60px; margin-bottom: 5px; border-radius: 4px;">

                    </div>
                    <div class="col-md-6 form-group">
                        <label for="input-name">Package Name</label>
                        <input value="{{ $package->name }}" name="name" type="text" class="form-control" id="name"
                               placeholder="Enter Package Name" required>
                    </div>
                </div>
            </div>

        </div>

        <div class="row">
            <template x-for="(item, index) in selected" :key="item">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header" style="background: white;">
                            <div class="float-right">
                                <button @click="removeSelected(index)" class="btn btn-sm btn-danger">&times;</button>
                            </div>
                            <div class="row" style="align-items: center;">
                                <img class="rounded-circle mr-4" :src="'/storage/'+item.product.image"
                                     style="height: 60px; width: 60px; margin-bottom: 5px; border-radius: 4px;">
                                <h5 x-text="item.product.name"></h5>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Please Enter Total Unit</label>
                                        <input x-model="item.total_unit" type="text" class="form-control"
                                               placeholder="Total Unit">
                                    </div>
                                </div>
                            </div>

                            <table class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="10%">Unit</th>
                                    <th width="10%">MRP</th>
                                    <th width="10%">Quantity</th>
                                    <th width="10%">Total</th>
                                    {{-- <th width="10%">Action</th> --}}
                                </tr>
                                </thead>
                                <tbody>
                                <template x-for="(te, id) in item.variations">
                                    <tr>
                                        <td x-text="id+1"></td>
                                        <td x-text="te.variant.unit"></td>
                                        <td class="text-red" x-text="te.variant.mrp.currency"></td>
                                        <td x-text="te.quantity"></td>
                                        <td class="text-red text-bold" x-text="'₹'+te.total"></td>
                                        {{-- <td @click="removeVariation(index, id)" class="text-center">
                                            <i class="fa fa-trash text-red"></i>
                                        </td> --}}
                                    </tr>
                                </template>
                                </tbody>
                            </table>
                        </div>

                        <div class="card-footer">
                            <p class="float-right font-weight-bold text-red">Rs. <span x-text="item.price"></span></p>
                        </div>

                    </div>
                </div>
            </template>

            <div class="col-md-12">
                <div class="card" style="height: 170px;">
                    <div class="card-body d-flex"
                         style="align-items: center;justify-content: center;background:#b7b7b7;">
                        <button class="btn btn-primary" data-toggle="modal" data-target="#myModal">Add Product</button>
                    </div>
                </div>
            </div>
        </div>


        <div class="card">
            <div class="card-footer" style="background: white;">
                <button @click="submit()" class="btn btn-block btn-success">UPDATE</button>
            </div>
        </div>

        <!-- Product Modal -->
        <div class="modal" id="myModal">
            <div class="modal-dialog modal-lg modal-dialog-scrollable">
                <div class="modal-content">
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">All Product</h4>
                        <button @click="toggle()" type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>

                    <!-- Modal body -->
                    <div class="modal-body">

                        <div x-show="step == true">
                            <table id="products-table" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Product Name</th>
                                    <th>Image</th>
                                    <th>Select</th>
                                </tr>
                                </thead>
                                <tbody>
                                <template x-for="product in products">
                                    <tr>
                                        <td x-text="product.id"></td>
                                        <td x-text="product.name"></td>
                                        <td>
                                            <img :src="'/storage/'+product.image"
                                                 style="height: 30px; margin-bottom: 5px; border-radius: 4px;">
                                        </td>
                                        <td>
                                            <button @click="selectProduct(product)" type="button"
                                                    class="btn btn-primary">Select
                                            </button>
                                        </td>
                                    </tr>
                                </template>
                                </tbody>
                            </table>
                        </div>

                        <div x-show="step == false">
                            <table class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="10%">Unit</th>
                                    <th width="10%">MRP</th>
                                    <th width="10%">Quantity</th>
                                </tr>
                                </thead>
                                <tbody>
                                <template x-for="(variant, pos) in variants">
                                    <tr>
                                        <td x-text="pos+1"></td>
                                        <td x-text="variant.variant.unit"></td>
                                        <td class="text-red" x-text="'₹'+variant.variant.mrp.amount"></td>
                                        <td>
                                            <input x-model="variant.quantity" type="number" value="0" min="0" max="100"
                                                   step="1"/>
                                        </td>
                                    </tr>
                                </template>
                                </tbody>
                            </table>
                            <button @click="selectVariation()" data-dismiss="modal" type="button"
                                    class="btn btn-block btn-outline-primary">Add
                            </button>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function () {
            $('#products-table').DataTable();

            $("#someDiv").bind("DOMSubtreeModified", function () {
                $("input[type='number']").each(function () {
                    if (!$(this).hasClass('applied'))
                        $(this).addClass('applied').inputSpinner({
                            buttonsOnly: true
                        });
                });
            });
        });

        function data() {
            return {
                products: @json($products),
                package: @json($package),
                selected: @json($package->products),
                deleted: [],
                step: true,
                prod: {},
                variants: [],

                check() {
                    if (this.selected == null) {
                        this.selected = [];
                    }
                },

                selectProduct(product) {
                    const isAdded = this.selected.find(x => x.product_id === product.id);

                    if (isAdded != null) {
                        Swal.fire({
                            title: 'Peoduct Already Exists!',
                            text: 'Please Slect Another Product',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                        return;
                    }

                    this.prod = product;
                    this.variants = [];

                    if (product.variants == null) {
                        toastr.error(product.name + ' does not have any variants!');
                        return;
                    }

                    product.variants.forEach(element => {
                        const item = {
                            variant: element,
                            quantity: 0,
                        };

                        this.variants.push(item);
                    });

                    this.step = false;
                },

                selectVariation() {
                    let item = {
                        product: this.prod,
                        product_id: this.prod.id,
                        package_id: this.package.id,
                        price: 0,
                        total_unit: '',
                        variations: [],
                        deleted: {package: [], variation: []},
                    };

                    this.variants.forEach(element => {
                        if (element.quantity <= 0) return;

                        const total = element.variant.mrp.amount * element.quantity;
                        item.price += total;

                        const variation = {
                            variant_id: element.variant.id,
                            variant: element.variant,
                            quantity: element.quantity,
                            total: total,
                        };

                        item.variations.push(variation);
                    });

                    this.selected.push(item);

                    this.prod = {};
                    this.variants = [];
                    this.step = true;
                },

                removeVariation(index, position) {
                    this.selected[index].variations.splice(position, 1);
                },

                removeSelected(index) {
                    if (this.selected[index].id != null) {
                        this.deleted.push(this.selected[index].id);
                    }
                    this.selected.splice(index, 1);
                },

                submit() {
                    const route = '{{ route('packages.product.update', $package->id) }}';
                    const update = [];
                    const create = [];

                    this.selected.forEach(element => {
                        if (element.id != null) {
                            update.push(element);
                        } else {
                            create.push(element);
                        }
                    });

                    const data = {
                        create: create,
                        update: update,
                        deleted: this.deleted,
                    };

                    axios
                        .post(route, data)
                        .then(() => {
                            window.history.go(-1);
                        });
                },

                toggle() {
                    this.step = true;
                },
            };
        }
    </script>
@endpush
