@extends('layouts.admin')

@section('title', 'Create Pincodes')

@section('content')
    <div class="card" x-data="data()">
        <form method="POST" action="{{ route('pincodes.store') }}">
            @csrf
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <x-input-form id="pincode" name="pincode" label="Pincode"/>
                    </div>

                    <template x-for="(item, index) in areas" :key="item">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header no-border">
                                    <div class="card-tools">
                                        <i @click="remove(index)" class="fa fa-trash btn btn-sm btn-danger" style="color: #fff;"></i>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label :for="'area'+index">Area Name</label>

                                        <input name="areas[]" type="text" :id="'area'+index" placeholder="Enter Area Name"
                                               class="form-control">

                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
                <button type="button" class="btn btn-primary" @click="add()">ADD AREA</button>
            </div>

            <x-btn-submit/>
        </form>
    </div>

@endsection

@push('scripts')
    <script>
        function data() {
            return {
                areas: [],

                remove(index) {
                    this.areas.splice(index, 1);
                },

                add() {
                    this.areas.push({area: ''});
                },
            };
        }
    </script>
@endpush
