@extends('layouts.admin')

@section('title', 'Create Product')

@section('content')
    <div class="card">

        <form method="POST" action="{{ route('products.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">

                    <div class="col-md-12 text-center mb-5">
                        <img id="imgProduct" src="{{ env('BLANK_IMAGE') }}" style="height: 100px; border-radius: 4px;">
                    </div>

                    <div class="col-md-6">
                        <x-input-file id="inputProduct" label="Select a Image" img="imgProduct"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-form id="name" name="name" label="Product Name"/>
                    </div>

                    <div class="col-md-12">
                        <x-input-select label="Brand" name="brand_id" id="brand" :disabled="false">
                            @foreach($brand as $values)
                                <option value="{{$values->id}}">{{$values->name}}</option>
                            @endforeach
                        </x-input-select>
                    </div>

                    <livewire:category-select>

                        <div class="col-md-6">
                            <x-input-select :disabled="false" :required="false" label="Place (Where you want to show?)" name="place"
                                            id="place">
                                <option value="home1">Home Screen 1</option>
                                <option value="home2">Home Screen 2</option>
                                <option value="home3">Home Screen 3</option>
                                <option value="category">Category Screen</option>
                            </x-input-select>
                        </div>

                        <div class="col-md-6">
                            <x-input-select label="In Stock" name="in_stock" id="inStock">
                                <option value="1">In Stock</option>
                                <option value="0">Out Of Stock</option>
                            </x-input-select>
                        </div>

                        <div class="col-md-6">
                            <x-input-form :required="false" type="number" id="sort" name="sort" label="Sort" value="0"/>
                        </div>

                        <div class="col-md-6">
                            <x-status/>
                        </div>

                        <div class="col-md-12 form-group">
                            <label for="descripion">Product Description</label>
                            <textarea class="@error('description')is-invalid @enderror" name="description"
                                      id="descripion"></textarea>
                            @error('description')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>

                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-success  btn-block">CREATE</button>
            </div>
        </form>
    </div>
@endsection
