@extends('layouts.admin')

@section('title', 'Product Variant')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Product Details</h3>
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6 form-group">
                    <label for="exampleInputFile">Preview</label>
                    <div class="clearfix"></div>

                    <img src="{{  Storage::url($product->image) }}"
                         style="height: 60px; margin-bottom: 5px; border-radius: 4px;">

                </div>
                <div class="col-md-6 form-group">
                    <label for="input-name">Product Name</label>
                    <input value="{{ $product->name }}" name="name" type="text" class="form-control" id="name"
                           placeholder="Enter Product Name" required>
                </div>
            </div>
        </div>

    </div>

    <div x-data="data()" x-init="check()">
        <div class="row">
            <template x-for="(item, index) in variants" :key="item">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <div class="float-right">
                                <button @click="remove(index)" class="btn btn-sm btn-danger">&times;</button>
                            </div>

                            <div class="form-row mt-4">
                                <div class="form-group col-md-6">
                                    <label for="unit">Unit Name</label>
                                    <input x-model="item.unit" type="text" class="form-control"
                                           :class="invaildClass(index, 'unit')" id="unit" placeholder="Unit Name">
                                    <div x-show="isNotValid(index, 'unit')" class="invalid-feedback">
                                        Please Enter A Unit
                                    </div>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="mrp">MRP</label>
                                    <input x-model="item.mrp" type="number" class="form-control" id="mrp"
                                           placeholder="Unit MRP" :class="invaildClass(index, 'mrp')">
                                    <div x-show="isNotValid(index, 'mrp')" class="invalid-feedback">
                                        Please Enter MRP
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="discountType">Discount Type</label>
                                    <select x-model="item.discount_type" id="discountType" class="form-control">
                                        <option value="none">No Discount</option>
                                        <option value="flat">Flat Discount</option>
                                        <option value="percentage">Percentage Discount</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="discount">Discount Amount</label>
                                    <input x-model="item.discount" type="number" class="form-control" id="discount"
                                           placeholder="Discount Ammount" :class="invaildClass(index, 'discount')">
                                    <div x-show="isNotValid(index, 'discount')" class="invalid-feedback">
                                        Please Enter Discount
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea x-model="item.description" class="form-control" id="description"
                                          rows="3" :class="invaildClass(index, 'description')"></textarea>
                                <div x-show="isNotValid(index, 'description')" class="invalid-feedback">
                                    Please Enter Description
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </template>

            <div class="col-md-6">
                <div class="card" style="height: 370px;">
                    <div class="card-body d-flex"
                         style="align-items: center;justify-content: center;background:#b7b7b7;">
                        <button @click="add()" class="btn btn-primary">Add Varition</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-footer">
                <button @click="submit()" class="btn btn-block btn-success">UPDATE</button>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function data() {
            return {
                variants: @json($variants),
                deleted: [],
                errors: {},

                check() {
                    if (this.variants == null) {
                        this.variants = [];
                    }else {
                       this.variants = this.variants.map(function (el) {
                           el.mrp = el.mrp.amount;
                           return el;
                       });
                    }
                },

                add() {
                    const item = {
                        unit: '',
                        mrp: '',
                        discount_type: 'none',
                        discount: 0,
                        description: '',
                        product_id: @json($product).id
                    };
                    this.variants.push(item);
                },

                remove(index) {
                    if (this.variants[index].id != null) {
                        this.deleted.push(this.variants[index].id);
                    }
                    this.variants.splice(index, 1);
                },

                isNotValid(index, key) {
                    return (`variants.${index}.${key}` in this.errors);
                },

                invaildClass(index, key) {
                    return this.isNotValid(index, key) ? 'is-invalid' : '';
                },

                submit() {
                    const route = '{{ route('products.variant.update', $product->id) }}';
                    const data = {
                        variants: this.variants,
                        deleted: this.deleted,
                    };

                    axios
                        .post(route, data)
                        .then(() => {
                            window.history.go(-1);
                        })
                        .catch((error) => {
                            window.scrollTo(0, 0);
                            this.errors = error.response.data.errors;
                            toastr.error('Given Data Was Invalid');
                        });
                }
            };
        }
    </script>
@endpush

@push('style')
    <style>
        .box {
            box-sizing: border-box;
            border: 2px solid transparent;
            background-clip: padding-box;
        }
    </style>
@endpush
