@extends('layouts.admin')

@section('title', 'Admin Profile')

@section('content')
<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title" style="width: 50%;">Edit Profile</h3>
            </div>


            <form method="POST" action="{{ route('profile.update', $profile->id) }}">
                @csrf
                @method('PATCH')
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="input-name">Name</label>
                                <input value="{{$profile->name}}" name="name" type="text" class="form-control"
                                    id="input-name" placeholder="Enter User Name">
                            </div>
                        </div>

                        @if(auth()->user()->type=='vendor')
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="input-name">Store Name</label>
                                <input value="{{$profile->store_name}}" name="store_name" type="text"
                                    class="form-control" id="input-name" placeholder="Enter Store Name">
                            </div>
                        </div>


                        @endif

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="input-name">Username</label>
                                <input value="{{$profile->email}}" name="email" type="text" class="form-control"
                                    id="input-name" placeholder="Enter Email Address" readonly="">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="input-name">Phone</label>
                                <input value="{{$profile->phone}}" name="phone" type="text" class="form-control"
                                    id="input-name" placeholder="Enter Phone Number">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="input-name">Address</label>
                                <input value="{{$profile->address}}" name="address" type="text" class="form-control"
                                    id="input-name" placeholder="Enter Address">
                            </div>
                        </div>


                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="input-name">Pincode</label>
                                <input value="{{$profile->postcode}}" name="postcode" type="text" class="form-control"
                                    id="input-name" placeholder="Enter Pincode Number">
                            </div>
                        </div>




                    </div>
                </div>

                <x-btn-submit :update="true" />

            </form>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="card">

            <div class="card-header">
                <h3 class="card-title" style="width: 50%;">Change Password</h3>
                <div class="clearfix"></div>
            </div>


            <form method="POST" action="{{ route('profile.update', $profile->id) }}">

                @csrf
                @method('PATCH')

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="input-name">New Password</label>
                                <input value="" name="phone" type="password" class="form-control" id="input-name"
                                    placeholder="Enter Password" autocomplete="off">
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="input-name">Confirm New Password</label>
                                <input value="" name="password" type="password" class="form-control" id="input-name"
                                    placeholder="Enter Confirm Password">
                            </div>
                        </div>


                    </div>
                </div>

                <x-btn-submit :update="true" />

            </form>
        </div>
    </div>
</div>
@endsection