@extends('layouts.admin')

@section('title', 'All Slider')

@section('action')
<x-btn-insert :route="route('sliders.child.create', $slider->id)" title="Add Slider" /> 
@endsection
@section('content')

<div class="card mt-4">

   
    <!-- /.card-header -->
    <div class="card-body table-responsive">
        <table id="example" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th width="5%">#</th>
                   
                   <th width="50%">Image</th>
                    <th width="10%">Action</th>

                </tr>
            </thead>
            <tbody>
                @foreach($child as $sliders)
                <tr>
                    <td>{{$sliders->id}}</td>
                    <td>
                        <img src="{{ Storage::url($sliders->image) }}" style="height: 60px; margin-bottom: 5px; border-radius: 4px;">
                    </td>

                    

                    <td>
                        <div style="float: left; margin-right: 5px;">
                            <a href="{{ route('sliders.child.edit', [$slider->id,$sliders->id]) }}" style="color: #fff;"
                                class="btn btn-sm btn-primary">
                                <i class="fa fa-edit"></i>
                            </a>
                        </div>

                        <div style="float: left;">
                            <a href="{{ route('sliders.child.destroy', [$slider->id,$sliders->id]) }}" data-method="DELETE"
                                data-confirm="Are you sure?" data-title="Please confirm this action"
                                data-theme="sweetalert">
                                <i class="fa fa-trash btn btn-sm btn-danger" style="color: #fff;"></i>
                            </a>
                        </div>

                        <div class="clearfix"></div>
                    </td>

                </tr>

                @endforeach


            </tbody>

        </table>
    </div>


    <!-- /.card-body -->
</div>

<script>
  $(document).ready( function () {
      $('#example').DataTable();
  } );
</script>

@endsection