<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="robots" content="follow,index">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Inarrive Login</title>

	<link rel="stylesheet" href="{{ asset('css/auth.css') }}">
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">
</head>

<body>
	<div class="content-body">
		<div class="form-wrapper">
			<form class="bg-white" method="POST" action="{{ route('login') }}">
				@csrf
				<h1 class="text-title">Login to your store</h1>
				<div class="field-group">
					<label class="label" for="txt-email">Email address</label>
					<input value="{{ old('email') }}" class="input" type="text" id="txt-email" name="email" placeholder="johndoe@gmail.com" />
					@error('email')
					<span class="invalid-feedback" role="alert">
						<strong>{{ $message }}</strong>
					</span>
					@enderror
				</div>
				<div class="field-group">
					<label class="label" for="txt-password">Password</label>
					<input class="input" type="password" id="txt-password" name="password"
						placeholder="Enter password" />
					@error('password')
					<span class="invalid-feedback" role="alert">
						<strong>{{ $message }}</strong>
					</span>
					@enderror
				</div>

				<div class="field-group">
					<input class="btn-submit" type="submit" value="Log In" />
				</div>
			</form>
		</div>
	</div>
</body>

</html>
