@props(['id', 'name', 'label', 'type' => 'text', 'value' => null, 'class' => 'form-control', 'required' => true])



<div class="form-group">
    <label for="{{ $id }}">{{ $label }}</label>

    <input name="{{ $name }}" type="{{ $type }}" id="{{ $id }}" placeholder="Enter {{ $label }}"
        class="{{ $class }} @error($name)is-invalid @enderror" value="{{ $value ?? old($name) }}" {{ $required? 'required': '' }}>
    @error($name)
    <div class="invalid-feedback">
        {{ $message }}
    </div>
    @enderror
</div>