@props(['id', 'name', 'label', 'required' => true, 'disabled' => true])

<div class="form-group">
    <label for="{{ $id }}">{{ $label }}</label>
    <select name="{{ $name }}" class="form-control @error($name)is-invalid @enderror" {{ $required? 'required': '' }}>
        <option value="" {{ $disabled? 'disabled': '' }}>Select {{ $label }}</option>
        {{ $slot }}
    </select>
    <x-error :name="$name" />
</div>