<?php

use App\Http\Controllers\API\Auth\CustomerAuthController;
use App\Http\Controllers\API\Customer;
use App\Http\Controllers\API\Delivery;
use App\Http\Controllers\API\Vendor;
use Illuminate\Support\Facades\Route;

Route::post('login', [CustomerAuthController::class, 'login']);
Route::post('register', [CustomerAuthController::class, 'register']);

Route::get('home', Customer\Home\HomeController::class);
Route::get('categories', [Customer\Category\CategoryController::class, 'index']);
Route::get('categories/{category}/show', [Customer\Category\CategoryController::class, 'show']);
Route::get('categories/{category}/{subcategory}/show', [Customer\Category\CategoryController::class, 'showSubcategory']);
Route::get('categories/special/{category}', [Customer\Category\CategoryController::class, 'showSpecial']);

Route::get('products', [Customer\Product\ProductController::class, 'index']);
Route::get('products/{id}', [Customer\Product\ProductController::class, 'show']);
Route::get('product/search', [Customer\Product\SearchController::class, 'index']);

Route::get('brands/{id}', [Customer\Brand\BrandController::class, 'show']);

Route::get('deals/{category}', [Customer\Deal\DealController::class, 'show']);

Route::get('packages', [Customer\Package\PackageController::class, 'index']);
Route::get('packages/{package}', [Customer\Package\PackageController::class, 'show']);

Route::get('basket', [Customer\Basket\BasketController::class, 'index']);
Route::get('basket/{basket}', [Customer\Basket\BasketController::class, 'show']);

Route::get('common/info', [Customer\Common\CommonController::class, 'info']);
Route::get('common/faq', [Customer\Common\CommonController::class, 'faq']);
Route::get('common/privacy', [Customer\Common\CommonController::class, 'privacy']);
Route::get('common/terms', [Customer\Common\CommonController::class, 'terms']);
Route::get('common/donations', [Customer\Common\CommonController::class, 'donations']);
Route::post('common/complain', [Customer\Common\CommonController::class, 'complain']);

Route::get('posts', Customer\Address\PostController::class);

Route::middleware(['auth:sanctum', 'type.customer'])->group(function () {

// Address
    Route::get('address', [Customer\Address\AddressController::class, 'index']);
    Route::post('address', [Customer\Address\AddressController::class, 'store']);
    Route::get('address/{address}/delete', [Customer\Address\AddressController::class, 'destroy']);


// Cart
    Route::get('cart', [Customer\Cart\CartController::class, 'index']);
    Route::post('cart', [Customer\Cart\CartController::class, 'store']);
    Route::get('cart/{cart}/delete', [Customer\Cart\CartController::class, 'delete']);
    Route::get('cart/quantity', [Customer\Cart\CartController::class, 'cartCount']);
    Route::post('cart/{cart}/quantity/update', [Customer\Cart\CartController::class, 'updateQuantity']);

// Order Plan
    Route::get('counter/ready-plan', [Customer\Counter\CounterController::class, 'readyPlanCount']);

// Basket
    Route::post('basket/order', [Customer\Basket\BasketController::class, 'store']);

// Checkout
    Route::post('checkout', [Customer\Checkout\CheckoutController::class, 'createOrder']);

// Order
    Route::get('orders/all', [Customer\Order\OrderIndexController::class, 'all']);
    Route::get('orders/package', [Customer\Order\OrderIndexController::class, 'package']);

    Route::post('order', [Customer\Order\OrderController::class, 'store']);
    Route::get('order/{order}', [Customer\Order\OrderController::class, 'show']);
    Route::get('order/{order}/confirm', [Customer\Order\OrderController::class, 'confirmOrder']);
    Route::patch('order/{order}', [Customer\Order\OrderController::class, 'update']);

// Delivery
    Route::get('delivery', [Customer\Order\DeliveryController::class, 'index']);
    Route::post('delivery', [Customer\Order\DeliveryController::class, 'store']);
    Route::patch('delivery', [Customer\Order\DeliveryController::class, 'update']);
    Route::post('delivery/cancel', [Customer\Order\DeliveryController::class, 'destroy']);
    Route::get('delivery/{delivery}/delete', [Customer\Order\DeliveryController::class, 'destroyDelivery']);

//Wallet
    Route::get('wallet', [Customer\Wallet\WalletController::class, 'show']);
    Route::get('wallet/coupon', [Customer\Wallet\WalletController::class, 'coupon']);
    Route::post('wallet/reserve', [Customer\Wallet\WalletController::class, 'reserve']);
    Route::post('wallet/transfer', [Customer\Wallet\WalletController::class, 'transfer']);
    Route::post('wallet/search', Customer\Wallet\CustomerFinderController::class);
    Route::post('wallet/withdraw', [Customer\Wallet\WalletController::class, 'withdraw']);

// Profile
    Route::post('profile', [Customer\Profile\ProfileController::class, 'update']);

    Route::get('logout', [CustomerAuthController::class, 'logout']);
});

// Webhook
Route::post('webhook', [Customer\Checkout\WebhookController::class, 'handle']);
