<?php

use App\Http\Controllers\API\Auth\DeliveryAuthController;
use App\Http\Controllers\API\Customer;
use App\Http\Controllers\API\Delivery;
use Illuminate\Support\Facades\Route;

Route::post('login', [DeliveryAuthController::class, 'login']);

Route::middleware(['auth:sanctum', 'type.delivery'])->group(function () {

    // Deliveries
    Route::get('deliveries/unassigned', [Delivery\Delivery\DeliveryRequestController::class, 'index']);
    Route::post('deliveries/assign', [Delivery\Delivery\DeliveryRequestController::class, 'update']);

    Route::get('deliveries', [Delivery\Delivery\DeliveryController::class, 'index']);
    Route::post('deliveries', [Delivery\Delivery\DeliveryController::class, 'update']);

    Route::post('deliveries/count', [Delivery\Delivery\DeliveryController::class, 'count']);

    // History
    Route::get('history', [Delivery\History\HistoryController::class, 'index']);

    //Wallet
    Route::get('wallet', [Delivery\Wallet\WalletController::class, 'show']);
    Route::get('wallet/coupon', [Delivery\Wallet\WalletController::class, 'coupon']);
    Route::post('wallet/reserve', [Delivery\Wallet\WalletController::class, 'reserve']);
    Route::post('wallet/transfer', [Delivery\Wallet\WalletController::class, 'transfer']);
    Route::post('wallet/search', Customer\Wallet\CustomerFinderController::class);


    Route::get('logout', [DeliveryAuthController::class, 'logout']);
});
