<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class CustomerAuthTest extends TestCase
{
    public function testRequiredFieldsForRegistration()
    {
        $this->postJson('api/customers/v1/register')
            ->assertStatus(422)
            ->assertExactJson([
                "message" => "The given data was invalid.",
                "errors" => [
                    "first_name" => ["The first name field is required."],
                    "last_name" => ["The last name field is required."],
                    "phone" => ["The phone field is required."],
                    "password" => ["The password field is required."],
                    "image" => ["The image field is required."],
                    "aadhaar_front" => ["The aadhaar front field is required."],
                    "aadhaar_back" => ["The aadhaar back field is required."],
                ]
            ]);
    }
}
